const asyncHandler = require("express-async-handler")

var fs = require("fs");
var md5 = require("md5");



const { getVideoDurationInSeconds } = require("get-video-duration")


const ffmpegPath = require("@ffmpeg-installer/ffmpeg").path;
var ffmpeg = require("fluent-ffmpeg");
ffmpeg.setFfmpegPath(ffmpegPath);

const ffprobePath = require('@ffprobe-installer/ffprobe').path;
ffmpeg.setFfprobePath(ffprobePath);

const { exec } = require('child_process');

const ffprobe = require('ffprobe')
const ffprobeStatic = require('ffprobe-static')

const videoUploadReq = asyncHandler( async (req, res) => {
    res.send("All set to upload2!")
})



const allResolution = [{ scale: "320:240", size: "320x240" }, { scale: "640:360", size: "640x360" }, { scale: "640:480", size: "640x480" }, { scale: "1280:720", size: "1280x720" }, { scale: "1920:1080", size: "1920x1080" }, { scale: "3840:2160", size: "3840x2160" }];


const moonLanding = new Date();
const d = new Date();
let year = d.getUTCFullYear();
let month = (d.getMonth() + 1).toString().padStart(2, "0");

const videoUpload = asyncHandler( async (req, res) => {
    const { name, currentChunkIndex, totalChunks } = req.query;
    const firstChunk = parseInt(currentChunkIndex) === 0;
    const lastChunk = parseInt(currentChunkIndex) === parseInt(totalChunks) - 1;
    const ext = name.split('.').pop();
    const data = req.body.toString().split(',')[1];
    const buffer = Buffer.from(data, 'base64');
    

    var dir= `./upload/videos/${year}/${month}`
    var ssdir= `${year}/${month}`

    if (!fs.existsSync(dir)){
        fs.mkdirSync(dir, { recursive: true });
    }
    if (!fs.existsSync("./upload/photos/"+ ssdir)){
        fs.mkdirSync("./upload/photos/"+ ssdir, { recursive: true });
    }
    
    const tmpFilename = 'tmp_' + md5(name + req.ip+ moonLanding.getTime()) + '.' + ext;
    if (firstChunk && fs.existsSync(dir + "/" + tmpFilename)) {
        fs.unlinkSync(dir + "/" + tmpFilename);
    }
    fs.appendFileSync(dir + "/" + tmpFilename, buffer);
    if (lastChunk) {
        console.log("last chunk")
        const fileName = md5(Date.now()).substr(0, 6) + Math.floor(Math.random() * 1000)
        const finalFilename = fileName + '.' + ext;
        fs.renameSync(dir + "/" + tmpFilename, dir + "/" + finalFilename);

        const inputPath = dir + "/" + finalFilename;
        const outputPath = dir + "/" + "resolution-";

        const fileMetaData = await ffprobe(inputPath, { path: ffprobeStatic.path })

        console.log(fileMetaData.streams[0].height)
        
        getVideoDurationInSeconds(inputPath).then((duration) => {
            console.log(duration)
            ffmpeg()
                .input(inputPath)
                .on('error', (err) => {
                    // res.status(400).send(JSON.stringify({ "error": err.message }));
                    res.status(200).send(JSON.stringify({ finalFilename: ssdir + "/" +finalFilename, resolution: fileMetaData.streams[0].height, duration: duration, finalFileLocation: dir.substring(2) + "/" +finalFilename, thumbnail: false }));
                })
                .on('end', async function () {
                    res.status(200).send(JSON.stringify({ finalFilename: ssdir + "/" +finalFilename, resolution: fileMetaData.streams[0].height, duration: duration, finalFileLocation: dir.substring(2) + "/" +finalFilename, thumbnail: true }));
                })
                .screenshots({
                    count: 5,
                    filename: `${fileName}-screenshot-%i.jpg`,
                    folder: "./upload/photos/"+ ssdir + "/"
                });
            
        }).catch((error) => {
            console.log(error)
        })

    } else {
        res.json('ok');
    }
})


// const videoUploadOld = asyncHandler(async (req, res) => {
//     const { name, currentChunkIndex, totalChunks } = req.query;
//     const firstChunk = parseInt(currentChunkIndex) === 0;
//     const lastChunk = parseInt(currentChunkIndex) === parseInt(totalChunks) - 1;
//     const ext = name.split('.').pop();
//     const data = req.body.toString().split(',')[1];
//     const buffer = new Buffer.from(data, 'base64');
//     const tmpFilename = 'tmp_' + md5(name + req.ip) + '.' + ext;
//     if (firstChunk && fs.existsSync(dir + "/" + tmpFilename)) {
//         fs.unlinkSync(dir + "/" + tmpFilename);
//     }
//     fs.appendFileSync(dir + "/" + tmpFilename, buffer); console.log("chunking")
//     console.log(lastChunk)
//     console.log(totalChunks)
//     console.log(currentChunkIndex)
//     if (lastChunk) {
//         const finalFilename = md5(Date.now()).substr(0, 6) + '.' + ext;
//         fs.renameSync(dir + "/" + tmpFilename, dir + "/" + finalFilename);
//         res.json({ finalFilename });
//     } else {
//         res.json("ok");
//     }
// })



// module.exports = { videoUpload, videoUploadReq, videoUploadOld }
module.exports = {videoUpload ,  videoUploadReq }